{ *********************************************************************** }
{                                                                         }
{ Friends Telephone Drectory Demo                                         }
{                                                                         }
{ by Kris Golko                                                           }
{ Altair IV Ltd                                                           }
{                                                         London 2003     }
{ *********************************************************************** }

unit frmuMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, StdCtrls, Buttons, DB, DBXpress, SqlExpr,
  FMTBcd, Provider, DBClient, ActnList, Menus, System.ComponentModel;

type
  TfrmMain = class(TForm)
    btnQuit: TBitBtn;
    grdNames: TDBGrid;
    dsTel: TDataSource;
    brnDetails: TBitBtn;
    btnAdd: TBitBtn;
    ActionList1: TActionList;
    actAddFriend: TAction;
    btnApplyUpdates: TBitBtn;
    actFriendDetails: TAction;
    actCommitChanges: TAction;
    btnSearch: TBitBtn;
    actSearch: TAction;
    grdPhones: TDBGrid;
    dsPhones: TDataSource;
    BitBtn2: TBitBtn;
    actAddPhone: TAction;
    actSearchagain: TAction;
    actRemovePhone: TAction;
    BitBtn1: TBitBtn;
    MainMenu1: TMainMenu;
    Quit1: TMenuItem;
    About1: TMenuItem;
    procedure btnQuitClick(Sender: TObject);
    procedure actAddFriendExecute(Sender: TObject);
    procedure actCommitChangesUpdate(Sender: TObject);
    procedure actFriendDetailsExecute(Sender: TObject);
    procedure actCommitChangesExecute(Sender: TObject);
    procedure actAddPhoneExecute(Sender: TObject);
    procedure actSearchExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actSearchagainExecute(Sender: TObject);
    procedure actSearchagainUpdate(Sender: TObject);
    procedure actAddPhoneUpdate(Sender: TObject);
    procedure actRemovePhoneExecute(Sender: TObject);
    procedure actRemovePhoneUpdate(Sender: TObject);
    procedure Quit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
    FLastSearch: string;
    function DoSearch(SearchText: string; Continue: boolean): boolean;
    procedure ShowDetails(New: boolean);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses dmuTel, frmuTelDetails, frmuPhoneDetails, frmuSearch, frmuAbout;

{$R *.dfm}

function TfrmMain.DoSearch(SearchText: string; Continue: boolean): boolean;
var
  FriendId: integer;
begin
  FLastSearch := SearchText;
  FriendId := dmTel.cdsFriends.FieldByName('FRIENDID').AsInteger;
  dmTel.cdsFriends.DisableControls;
  try
    if Continue then
      dmTel.cdsFriends.Next
    else
      dmTel.cdsFriends.First;
    while not dmTel.cdsFriends.EOF do
    begin
      if Pos(FLastSearch, UpperCase(dmTel.cdsFriends.FieldByName('NAME').AsString))
          <> 0 then Break;
      dmTel.cdsFriends.Next;
    end;
    if dmTel.cdsFriends.EOF then
    begin
      dmTel.cdsFriends.Locate('FRIENDID', FriendId, []);
      Result := false;
    end
    else
      Result := true;
  finally
    dmTel.cdsFriends.EnableControls;
  end;
end;

procedure TfrmMain.ShowDetails(New: boolean);
var
  frmTelDetails: TfrmTelDetails;
begin
  frmTelDetails := TfrmTelDetails.Create(Application, New);
  try
    frmTelDetails.ShowModal;
  finally
    frmTelDetails.Free;
  end;
end;

procedure TfrmMain.btnQuitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.actAddFriendExecute(Sender: TObject);
begin
  ShowDetails(true);
  grdNames.SetFocus;
end;

procedure TfrmMain.actCommitChangesUpdate(Sender: TObject);
begin
  actCommitChanges.Enabled := dmTel.cdsFriends.ChangeCount > 0;
end;

procedure TfrmMain.actFriendDetailsExecute(Sender: TObject);
begin
  ShowDetails(false);
  grdNames.SetFocus;
end;

procedure TfrmMain.actCommitChangesExecute(Sender: TObject);
begin
  try
    if dmTel.cdsFriends.ApplyUpdates(0) > 0 then
      Abort;
  finally
    grdNames.SetFocus;
  end;
end;

procedure TfrmMain.actAddPhoneExecute(Sender: TObject);
var
  frmPhoneDetails: TfrmPhoneDetails;
begin
  frmPhoneDetails := TfrmPhoneDetails.Create(Application, true);
  try
    frmPhoneDetails.ShowModal;
  finally
    frmPhoneDetails.Free;
    grdPhones.SetFocus;
  end;
end;

procedure TfrmMain.actSearchExecute(Sender: TObject);
var
  frmSearch: TfrmSearch;
begin
  frmSearch := TfrmSearch.Create(Application, FLastSearch);
  try
    while frmSearch.ShowModal <> mrCancel do
    begin
      if not DoSearch(frmSearch.Value, frmSearch.ModalResult = mrOk) then
        MessageDlg('Friend not found', mtInformation, [mbOk], 0)
      else
        Break;
    end;
  finally
    frmSearch.Free;
  end;
  grdNames.SetFocus;
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if dmTel.cdsFriends.ChangeCount > 0 then
    case MessageDlg('Changes has been made to the directory. Do you want to save?',
                  mtConfirmation, mbYesNoCancel, 0) of
      mrYes:
        try
         if dmTel.cdsFriends.ApplyUpdates(0) > 0 then
          Abort;
        except
          Action := caNone;
          raise;
        end;
      mrCancel:
        Action := caNone;
     end;
end;

procedure TfrmMain.actSearchagainExecute(Sender: TObject);
begin
  if FLastSearch <> '' then
    if not DoSearch(FLastSearch, true) then
      MessageDlg('No matching names found', mtInformation, [mbOk], 0);
end;

procedure TfrmMain.actSearchAgainUpdate(Sender: TObject);
begin
  actSearchagain.Enabled := FLastSearch <> '';
end;

procedure TfrmMain.actAddPhoneUpdate(Sender: TObject);
begin
  actAddPhone.Enabled := dmTel.cdsFriends.RecordCount > 0;
end;

procedure TfrmMain.actRemovePhoneExecute(Sender: TObject);
begin
  if MessageDlg('Are you sure to remove this number?', mtConfirmation, mbOkCancel, 0) = mrOk then
    dmTel.cdsPhones.Delete;
  grdPhones.SetFocus;
end;

procedure TfrmMain.actRemovePhoneUpdate(Sender: TObject);
begin
  actRemovePhone.Enabled := dmTel.cdsFriends.RecordCount > 0;
end;

procedure TfrmMain.Quit1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.About1Click(Sender: TObject);
var
  frmAbout: TfrmAbout;
begin
  frmAbout := TfrmAbout.Create(Application);
  frmAbout.ShowModal;
  frmAbout.Free;
end;

end.
